<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg="." version="1.0">
  <!--
BOSCH Security Sytems (Ottobrunn)

Project: Magic.Panel

Author: Michael Ziegel

Created: 01.10.2005

$Archive:   //ot1esw2/MagicPanel/PVCS MP-SW/archives/MP_SW/MP_PC_SW/Transformer/Conversion/XSLT/conv-1-0-0-to-1-1-0.xsl-arc  $  

$Revision: 1.8 $ 

Last locked:   $Date: 2008/10/06 10:23:32GMT $

Last change by $Author: Michael Ziegel (zi82ot) $

History: 
$Log: XSLT/conv-1-3-0-to-lt-1-3-0.xsl  $
Revision 1.8 2008/10/06 10:23:32GMT Michael Ziegel (zi82ot) 
Member moved from Conversion/XSLT/conv-1-3-0-to-lt-1-3-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to XSLT/conv-1-3-0-to-lt-1-3-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj.
Revision 1.7 2008/10/06 12:23:32CEST Michael Ziegel (zi82ot) 
revision control added
Revision 1.6 2006/12/07 17:23:27CET zi82ot 
drop autodetectors
Revision 1.5 2006/11/29 13:36:21CET zi82ot 
HEADER structure transformed to old form to avoid validation and trafo errors (warnings)
Revision 1.4 2006/11/07 14:56:19CET zi82ot 
If value in local TransmissionTable is ST_YES, but no offset in GlobalOffsetTable set to NotTransmitted
Revision 1.3 2006/09/28 12:43:28CEST zi82ot 
Conversions implemented
Revision 1.2 2006/09/19 14:35:18CEST zi82ot 
down-conversion implemented
Revision 1.1 2006/09/13 15:21:26CEST zi82ot 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
Revision 1.3 2006/03/27 14:19:37CEST admin 
PVCs current 270306

-->
  <cfg:Stylesheet version="$Revision: 1.8 $"/>
  <xsl:output method="xml" indent="yes"/>
  <xsl:param name="newversion" select="'0.0.0'"/>
  <xsl:variable name="NOT_TRANS" select="'Not Transmitted'"/>
  <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
  <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()">
    </xsl:apply-templates>
    </xsl:element>
  </xsl:template>
  <!-- explicitly copy attributes -->
  <xsl:template match="@*">
    <xsl:copy/>
  </xsl:template>
  <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
  <!-- HEADER must be converted to the pre 1.3.0 form -->
  <xsl:template match="HEADER">
    <xsl:element name="HEADER">
      <xsl:element name="filename">
        <xsl:value-of select="filename"/>
      </xsl:element>
      <xsl:element name="revNumber">
        <xsl:value-of select="revNumber"/>
      </xsl:element>
      <xsl:element name="lastModified">
        <xsl:value-of select="lastModified"/>
      </xsl:element>
      <xsl:element name="dataVersion">
        <xsl:value-of select="$newversion"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- Remove ADDRESS_MANAGEMENT -->
  <xsl:template match="LOGICAL_GROUPING/ADDRESS_MANAGEMENT"> </xsl:template>
  <!-- Convert MTS_ADMIN -->
  <xsl:template match="LOGICAL_GROUPING/MTS_ADMIN">
    <xsl:if test="MTS">
      <xsl:element name="FAT_ADMIN">
        <xsl:for-each select="MTS">
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!--  new element MTS from old FAT-->
  <xsl:template match="MTS_ADMIN/MTS">
    <xsl:element name="FAT">
      <xsl:element name="siNumber">
        <xsl:value-of select="siNumber"/>
      </xsl:element>
      <xsl:element name="label">
        <xsl:value-of select="label"/>
      </xsl:element>
      <xsl:element name="connectedWith">
        <xsl:value-of select="MTS_CONNECTION/connectedWith[1]"/>
      </xsl:element>
      <xsl:for-each select="TRANSMISSION_TABLE/*">
        <xsl:element name="{name()}">
          <xsl:choose>
            <xsl:when test=". = 'ST_NO'">
              <xsl:value-of select="$NOT_TRANS"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:variable name="NodeName">
                <xsl:value-of select="name()"/>
              </xsl:variable>
              <xsl:for-each select="//GLOBAL_OFFSET_TABLE/*">
                <xsl:if test="name() = $NodeName">
                  <xsl:choose>
                    <xsl:when test="node()">
                      <xsl:value-of select="."/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$NOT_TRANS"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:if>
              </xsl:for-each>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:for-each>
      <xsl:for-each select="MTS_CONNECTION/*">
        <xsl:if test="name() = 'UART' or name() = 'OB_UART'">
          <xsl:element name="{name()}">
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- drop automaticDetectors -->
  <xsl:template match="GLTZONE/automaticDetectors">
  </xsl:template>
  <!-- drop automaticDetectors -->
  <xsl:template match="GLTZONE_LSNI_CONV4/automaticDetectors">
  </xsl:template>
  <!-- drop automaticDetectors -->
  <xsl:template match="GLTZONEKD/automaticDetectors">
  </xsl:template>
  <!-- drop automaticDetectors -->
  <xsl:template match="DOW1171/automaticDetector">
  </xsl:template>
</xsl:stylesheet>
